%Function: Import the raw data from the xml output files

%Inputs: 
%filename - name of the xml file (note must be in a MATLAB directory)
%DDgates - default value is [5000,25000], this 1x2 array has the min and
%   max values for the doublet discriminator on the bioplex.
%regionlist - this is the list of the bead regions used in the experiment,
%   should be formatted as a 1xN array where N is the number of bead
%   regions

%Outputs:
%reporter - the output of this is a formatted cell array that contains all
%   individual bead information for each bead region in each of the wells

function [reporter] = MultiPlexAnlys_XMLImport(filename,...
DDgates, regionlist)

xDoc = xmlread(filename);

allListitems = xDoc.getElementsByTagName('BeadEventData');

samplenum = allListitems.getLength;

reporter = cell(samplenum*length(regionlist),1);

for i = 1:samplenum;
    
    thisListitem = allListitems.item(i-1);
    
    thisElement = thisListitem.getFirstChild.getData;
    
    sampledata_i = str2num(char(thisElement));
    
    % set the doublet discriminator gates
    DD_max = DDgates(2);
    DD_min = DDgates(1);
    
    % filter the data to eliminate data points that do not satisfy the DD
    % requirements
    DDdata_max = sampledata_i(sampledata_i(:,2) <= DD_max,:);
    DDdata = DDdata_max(DDdata_max(:,2) >= DD_min,:);
    
    % loop over the bead regions used in the experiment
    for j=1:length(regionlist)
    
        % find the data points that are in region_j 
        classdata = DDdata(DDdata(:,1)==regionlist(j),:);
        
        % add the reporter data to the reporter cell (OUTPUT)
        reporter{(i-1)*length(regionlist)+j} = classdata(:,3);
        
    end
    
end